// @ts-ignore
import React from 'react';
import type { SVGProps } from 'react';

interface CustomIconProps extends SVGProps<SVGSVGElement> {
    size?: number;
    fill?: string;
    stroke?: string;
    strokeWidth?: number;
    viewBox?: string;
}

const restore: React.FC<CustomIconProps> = ({
    size = 24,
    fill = 'none',
    stroke = 'none',
    strokeWidth = 1,
    viewBox = '0 0 24 24',
    ...props
}) => (
    <svg
        width={size}
        height={size}
        viewBox={viewBox}
        fill={fill}
        xmlns="http://www.w3.org/2000/svg"
        {...props}
    >
        <path d="M12 21.7185C10.75 21.7185 9.57917 21.481 8.4875 21.006C7.39583 20.531 6.44583 19.8894 5.6375 19.081C4.82917 18.2727 4.1875 17.3227 3.7125 16.231C3.2375 15.1394 3 13.9685 3 12.7185C3 12.4352 3.09583 12.1977 3.2875 12.006C3.47917 11.8144 3.71667 11.7185 4 11.7185C4.28333 11.7185 4.52083 11.8144 4.7125 12.006C4.90417 12.1977 5 12.4352 5 12.7185C5 14.6685 5.67917 16.3227 7.0375 17.681C8.39583 19.0394 10.05 19.7185 12 19.7185C13.95 19.7185 15.6042 19.0394 16.9625 17.681C18.3208 16.3227 19 14.6685 19 12.7185C19 10.7685 18.3208 9.11435 16.9625 7.75602C15.6042 6.39768 13.95 5.71852 12 5.71852H11.85L12.7 6.56852C12.9 6.76852 12.9958 7.00185 12.9875 7.26852C12.9792 7.53518 12.8833 7.76852 12.7 7.96852C12.5 8.16852 12.2625 8.27268 11.9875 8.28102C11.7125 8.28935 11.475 8.19352 11.275 7.99352L8.7 5.41852C8.5 5.21852 8.4 4.98518 8.4 4.71852C8.4 4.45185 8.5 4.21852 8.7 4.01852L11.275 1.44352C11.475 1.24352 11.7125 1.14768 11.9875 1.15602C12.2625 1.16435 12.5 1.26852 12.7 1.46852C12.8833 1.66852 12.9792 1.90185 12.9875 2.16852C12.9958 2.43518 12.9 2.66852 12.7 2.86852L11.85 3.71852H12C13.25 3.71852 14.4208 3.95602 15.5125 4.43102C16.6042 4.90602 17.5542 5.54768 18.3625 6.35602C19.1708 7.16435 19.8125 8.11435 20.2875 9.20602C20.7625 10.2977 21 11.4685 21 12.7185C21 13.9685 20.7625 15.1394 20.2875 16.231C19.8125 17.3227 19.1708 18.2727 18.3625 19.081C17.5542 19.8894 16.6042 20.531 15.5125 21.006C14.4208 21.481 13.25 21.7185 12 21.7185Z"/>
    </svg>
);

export default restore;